/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.model;

import com.google.gson.JsonElement;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class TexturedModel {
    public static final Provider CUBE = TexturedModel.createDefault(TextureMapping::cube, ModelTemplates.CUBE_ALL);
    public static final Provider CUBE_INNER_FACES = TexturedModel.createDefault(TextureMapping::cube, ModelTemplates.CUBE_ALL_INNER_FACES);
    public static final Provider CUBE_MIRRORED = TexturedModel.createDefault(TextureMapping::cube, ModelTemplates.CUBE_MIRRORED_ALL);
    public static final Provider COLUMN = TexturedModel.createDefault(TextureMapping::column, ModelTemplates.CUBE_COLUMN);
    public static final Provider COLUMN_HORIZONTAL = TexturedModel.createDefault(TextureMapping::column, ModelTemplates.CUBE_COLUMN_HORIZONTAL);
    public static final Provider CUBE_TOP_BOTTOM = TexturedModel.createDefault(TextureMapping::cubeBottomTop, ModelTemplates.CUBE_BOTTOM_TOP);
    public static final Provider CUBE_TOP = TexturedModel.createDefault(TextureMapping::cubeTop, ModelTemplates.CUBE_TOP);
    public static final Provider ORIENTABLE_ONLY_TOP = TexturedModel.createDefault(TextureMapping::orientableCubeOnlyTop, ModelTemplates.CUBE_ORIENTABLE);
    public static final Provider ORIENTABLE = TexturedModel.createDefault(TextureMapping::orientableCube, ModelTemplates.CUBE_ORIENTABLE_TOP_BOTTOM);
    public static final Provider CARPET = TexturedModel.createDefault(TextureMapping::wool, ModelTemplates.CARPET);
    public static final Provider FLOWERBED_1 = TexturedModel.createDefault(TextureMapping::flowerbed, ModelTemplates.FLOWERBED_1);
    public static final Provider FLOWERBED_2 = TexturedModel.createDefault(TextureMapping::flowerbed, ModelTemplates.FLOWERBED_2);
    public static final Provider FLOWERBED_3 = TexturedModel.createDefault(TextureMapping::flowerbed, ModelTemplates.FLOWERBED_3);
    public static final Provider FLOWERBED_4 = TexturedModel.createDefault(TextureMapping::flowerbed, ModelTemplates.FLOWERBED_4);
    public static final Provider GLAZED_TERRACOTTA = TexturedModel.createDefault(TextureMapping::pattern, ModelTemplates.GLAZED_TERRACOTTA);
    public static final Provider CORAL_FAN = TexturedModel.createDefault(TextureMapping::fan, ModelTemplates.CORAL_FAN);
    public static final Provider PARTICLE_ONLY = TexturedModel.createDefault(TextureMapping::particle, ModelTemplates.PARTICLE_ONLY);
    public static final Provider ANVIL = TexturedModel.createDefault(TextureMapping::top, ModelTemplates.ANVIL);
    public static final Provider LEAVES = TexturedModel.createDefault(TextureMapping::cube, ModelTemplates.LEAVES);
    public static final Provider LANTERN = TexturedModel.createDefault(TextureMapping::lantern, ModelTemplates.LANTERN);
    public static final Provider HANGING_LANTERN = TexturedModel.createDefault(TextureMapping::lantern, ModelTemplates.HANGING_LANTERN);
    public static final Provider SEAGRASS = TexturedModel.createDefault(TextureMapping::defaultTexture, ModelTemplates.SEAGRASS);
    public static final Provider COLUMN_ALT = TexturedModel.createDefault(TextureMapping::logColumn, ModelTemplates.CUBE_COLUMN);
    public static final Provider COLUMN_HORIZONTAL_ALT = TexturedModel.createDefault(TextureMapping::logColumn, ModelTemplates.CUBE_COLUMN_HORIZONTAL);
    public static final Provider TOP_BOTTOM_WITH_WALL = TexturedModel.createDefault(TextureMapping::cubeBottomTopWithWall, ModelTemplates.CUBE_BOTTOM_TOP);
    public static final Provider COLUMN_WITH_WALL = TexturedModel.createDefault(TextureMapping::columnWithWall, ModelTemplates.CUBE_COLUMN);
    private final TextureMapping mapping;
    private final ModelTemplate template;

    private TexturedModel(TextureMapping p_125930_, ModelTemplate p_125931_) {
        this.mapping = p_125930_;
        this.template = p_125931_;
    }

    public ModelTemplate getTemplate() {
        return this.template;
    }

    public TextureMapping getMapping() {
        return this.mapping;
    }

    public TexturedModel updateTextures(Consumer<TextureMapping> p_125941_) {
        p_125941_.accept(this.mapping);
        return this;
    }

    public ResourceLocation create(Block p_125938_, BiConsumer<ResourceLocation, Supplier<JsonElement>> p_125939_) {
        return this.template.create(p_125938_, this.mapping, p_125939_);
    }

    public ResourceLocation createWithSuffix(Block p_125934_, String p_125935_, BiConsumer<ResourceLocation, Supplier<JsonElement>> p_125936_) {
        return this.template.createWithSuffix(p_125934_, p_125935_, this.mapping, p_125936_);
    }

    private static Provider createDefault(Function<Block, TextureMapping> p_125943_, ModelTemplate p_125944_) {
        return p_125948_ -> new TexturedModel((TextureMapping)p_125943_.apply(p_125948_), p_125944_);
    }

    public static TexturedModel createAllSame(ResourceLocation p_125950_) {
        return new TexturedModel(TextureMapping.cube(p_125950_), ModelTemplates.CUBE_ALL);
    }

    @FunctionalInterface
    public static interface Provider {
        public TexturedModel get(Block var1);

        default public ResourceLocation create(Block p_125957_, BiConsumer<ResourceLocation, Supplier<JsonElement>> p_125958_) {
            return this.get(p_125957_).create(p_125957_, p_125958_);
        }

        default public ResourceLocation createWithSuffix(Block p_125953_, String p_125954_, BiConsumer<ResourceLocation, Supplier<JsonElement>> p_125955_) {
            return this.get(p_125953_).createWithSuffix(p_125953_, p_125954_, p_125955_);
        }

        default public Provider updateTexture(Consumer<TextureMapping> p_125960_) {
            return p_125963_ -> this.get(p_125963_).updateTextures(p_125960_);
        }
    }
}

